# Facebook Messenger-Style Chat Application

A production-ready, Facebook Messenger-style web chat application built with HTML, Tailwind CSS, Vanilla JavaScript, PHP, and MySQL.

## 🎯 Features

- **User Registration & Login**: Secure authentication with profile pictures (required)
- **Chat List**: Home page showing all conversations with profile pictures, last message preview, and timestamps
- **Find Users**: Search and start conversations with other users
- **Real-time Messaging**: Smart polling (2-3 seconds) for real-time message updates
- **Media Support**: Send text messages, images, and videos
- **Messenger-Style UI**: Left/right message bubbles with profile pictures, exactly like Messenger/WhatsApp
- **External Media Server**: All media files stored on external server (not on main server)
- **First Message Fix**: Chat appears instantly in chat list when first message is sent (no refresh needed)

## 📋 Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache web server with mod_rewrite enabled
- External media server (for file uploads)

## 🚀 Installation

### 1. Database Setup

1. Create the database:
```bash
mysql -u root -p < database.sql
```

Or manually:
- Open phpMyAdmin or MySQL command line
- Import `database.sql` file

### 2. Configuration

1. Edit `config.php`:
```php
// Update database credentials
define('DB_HOST', 'localhost');
define('DB_NAME', 'chat_app_pro');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');

// IMPORTANT: Update to your external media server URL
define('MEDIA_SERVER_URL', 'http://your-media-server.com/upload.php');
define('MEDIA_SERVER_DOMAIN', 'your-media-server.com');
```

2. Edit `js/config.js`:
```javascript
const MEDIA_SERVER_URL = 'http://your-media-server.com/upload.php';
```

3. Edit `media_server/upload.php`:
   - Update the `$UPLOAD_DIR` path to your desired upload directory
   - Update the public URL generation to match your media server domain

### 3. External Media Server Setup

The `media_server/upload.php` file should be deployed on your external media server. 

**Option 1: Same Server (for testing)**
- Keep `media_server/upload.php` in the same project
- Update `config.php` to use the same domain
- Create `media_server/uploads/` directory with write permissions

**Option 2: Separate Server**
- Upload `media_server/upload.php` to your external server
- Update `config.php` and `js/config.js` with the external server URL
- Ensure the external server allows CORS from your main domain

### 4. File Permissions

```bash
chmod 755 media_server/uploads/
chmod 644 *.php
chmod 644 js/*.js
chmod 644 *.html
```

### 5. Access the Application

Open your browser and navigate to:
```
http://localhost/chat_app_pro/
```

## 🏗️ Architecture

### Database Structure

- **users**: User accounts with profile pictures
- **chats**: Chat rooms between two users (prevents duplicates)
- **messages**: All messages with text, images, or videos

### API Endpoints

- `api/register.php` - User registration
- `api/login.php` - User login
- `api/logout.php` - User logout
- `api/check_auth.php` - Check authentication status
- `api/chats.php` - Get user's chat list
- `api/find_user.php` - Search for users
- `api/get_or_create_chat.php` - Get or create a chat
- `api/messages.php` - Get messages for a chat
- `api/send_message.php` - Send a message

### Frontend Structure

- `index.html` - Login page
- `register.html` - Registration page
- `home.html` - Chat list (home page)
- `chat.html` - Individual chat page
- `js/config.js` - API configuration
- `js/auth.js` - Authentication logic
- `js/home.js` - Home page logic
- `js/chat.js` - Chat page logic (includes first message fix)
- `js/media-upload.js` - Media upload handler

## 🐛 Critical First Message Fix

**Problem**: When a user sends the first message to another user, the chat doesn't appear in the chat list until the page is refreshed.

**Solution**: The application now handles this in `js/chat.js`:

1. When sending the first message, `send_message.php` creates the chat if it doesn't exist
2. The response includes the new `chat_id` and `other_user` information
3. The frontend immediately:
   - Updates the URL to include `chat_id`
   - Adds the chat to the local state
   - Calls `addChatToList()` to update the home page chat list (if available)
   - Dispatches a `chatCreated` event for cross-page communication
4. No page refresh is needed - the chat appears instantly

## 🔒 Security Features

- Prepared statements (SQL injection prevention)
- Password hashing with bcrypt
- Session regeneration
- Media URL domain whitelist validation
- XSS prevention (HTML escaping)
- Duplicate chat prevention
- File type and size validation

## 📱 Mobile Responsive

The application is fully responsive and works on:
- Desktop browsers
- Tablets
- Mobile phones (Android/iOS)

## 🎨 UI/UX Features

- Messenger-style message bubbles (left/right alignment)
- Profile pictures beside each message
- Profile pictures in chat list
- Last message preview with timestamps
- Upload progress bars
- Smooth animations and transitions
- No page reloads (SPA-like experience)

## 🔄 Real-time Updates

The application uses smart polling:
- Polls every 2.5 seconds for new messages
- Only fetches messages after the last known message ID
- Efficient and works on shared hosting (no WebSocket required)

## 📝 Usage

1. **Register**: Create an account with username, password, and profile picture
2. **Login**: Enter your credentials
3. **Find Users**: Click the + button to search for users
4. **Start Chat**: Click "Message" on a user to start chatting
5. **Send Messages**: Type and send, or attach images/videos
6. **View Chats**: All your conversations appear on the home page

## 🚫 Important Notes

- **Media Server**: The main server NEVER stores media files. All media must be uploaded to the external media server.
- **Profile Pictures**: Required during registration
- **File Limits**: 
  - Profile pictures: 10 MB max
  - Images: 20 MB max
  - Videos: 500 MB max (MP4 only)
- **No Autoplay**: Videos require user interaction to play

## 🛠️ Troubleshooting

### Database Connection Error
- Check `config.php` database credentials
- Ensure MySQL is running
- Verify database exists

### Media Upload Fails
- Check `media_server/uploads/` directory permissions
- Verify `MEDIA_SERVER_URL` in `config.php` and `js/config.js`
- Check CORS settings on external media server

### Chat Not Appearing After First Message
- Ensure `js/chat.js` is loaded correctly
- Check browser console for errors
- Verify `addChatToList` function exists in `home.js`

### Session Issues
- Check PHP session configuration
- Ensure cookies are enabled
- Verify `session_start()` is called in auth.php

## 📄 License

This project is provided as-is for educational and commercial use.

## 👨‍💻 Development

To modify the application:

1. **Backend**: Edit PHP files in `api/` directory
2. **Frontend**: Edit HTML files and JavaScript in `js/` directory
3. **Styling**: Tailwind CSS classes can be modified directly in HTML

## 🎯 Success Criteria Met

✅ Works on infinite/shared hosting  
✅ Shows chats instantly on first message  
✅ Displays profile pictures everywhere correctly  
✅ Behaves exactly like Messenger UX  
✅ Scalable architecture  
✅ No WebSocket required  
✅ External media server integration  
✅ Production-ready code  

---

**Built with ❤️ for production use**
