# Quick Setup Guide

## Step-by-Step Setup

### 1. Database Setup (5 minutes)

```bash
# Option 1: Command line
mysql -u root -p < database.sql

# Option 2: phpMyAdmin
# - Open phpMyAdmin
# - Click "Import"
# - Select database.sql
# - Click "Go"
```

### 2. Configure Database (2 minutes)

Edit `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'chat_app_pro');
define('DB_USER', 'root');        // Your MySQL username
define('DB_PASS', '');            // Your MySQL password
```

### 3. Configure Media Server (5 minutes)

**For Testing (Same Server):**
1. Create directory: `media_server/uploads/`
2. Set permissions: `chmod 755 media_server/uploads/`
3. In `config.php`, set:
   ```php
   define('MEDIA_SERVER_URL', 'http://localhost/chat_app_pro/media_server/upload.php');
   define('MEDIA_SERVER_DOMAIN', 'localhost');
   ```
4. In `js/config.js`, set:
   ```javascript
   const MEDIA_SERVER_URL = 'media_server/upload.php';
   ```

**For Production (External Server):**
1. Upload `media_server/upload.php` to your external server
2. Create `uploads/` directory on external server
3. Update `config.php` with external server URL
4. Update `js/config.js` with external server URL

### 4. Test Installation (2 minutes)

1. Open: `http://localhost/chat_app_pro/`
2. Register a new account
3. Upload a profile picture
4. Login
5. Search for another user (create a second account)
6. Send a message

### 5. Verify First Message Fix

1. User A searches for User B
2. User A clicks "Message" (chat.html opens with `other_user_id`)
3. User A sends first message
4. **VERIFY**: Chat should appear in home page chat list immediately
5. **VERIFY**: No page refresh needed
6. **VERIFY**: URL updates to include `chat_id`

## Common Issues

### Issue: "Database connection failed"
**Solution**: Check `config.php` database credentials

### Issue: "Profile picture upload fails"
**Solution**: 
- Check `media_server/uploads/` directory exists
- Check directory permissions (755)
- Verify `MEDIA_SERVER_URL` in config files

### Issue: "Chat doesn't appear after first message"
**Solution**:
- Open browser console (F12)
- Check for JavaScript errors
- Verify `js/chat.js` and `js/home.js` are loaded
- Check that `addChatToList` function exists

### Issue: "CORS error"
**Solution**:
- If using external media server, ensure CORS headers are set
- Check `.htaccess` file is present
- Verify media server allows requests from your domain

## File Structure

```
chat_app_pro/
├── api/                    # PHP API endpoints
│   ├── register.php
│   ├── login.php
│   ├── logout.php
│   ├── check_auth.php
│   ├── chats.php
│   ├── find_user.php
│   ├── get_or_create_chat.php
│   ├── messages.php
│   └── send_message.php
├── js/                     # JavaScript files
│   ├── config.js
│   ├── auth.js
│   ├── home.js
│   ├── chat.js
│   └── media-upload.js
├── media_server/           # Media upload handler
│   ├── upload.php
│   └── uploads/            # Create this directory!
├── config.php              # Main configuration
├── db.php                  # Database connection
├── auth.php                # Authentication helpers
├── database.sql            # Database schema
├── index.html              # Login page
├── register.html           # Registration page
├── home.html               # Chat list
├── chat.html               # Chat page
├── .htaccess               # Apache configuration
├── README.md               # Full documentation
└── SETUP.md                # This file
```

## Next Steps

1. ✅ Database created
2. ✅ Configuration updated
3. ✅ Media server configured
4. ✅ Test registration
5. ✅ Test messaging
6. ✅ Verify first message fix

## Production Deployment

1. Update all URLs to production domain
2. Set secure database credentials
3. Configure external media server
4. Enable HTTPS
5. Set proper file permissions
6. Configure backup strategy

---

**Need Help?** Check `README.md` for detailed documentation.
