<?php
/**
 * Block or unblock a user
 * POST: user_id, action (block|unblock)
 */

header('Content-Type: application/json');
require_once '../auth.php';
require_once '../db.php';

requireAuth();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$targetUserId = isset($input['user_id']) ? (int) $input['user_id'] : 0;
$action = trim($input['action'] ?? '');

if ($targetUserId <= 0 || !in_array($action, ['block', 'unblock'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid user_id or action']);
    exit;
}

$blockerId = (int) getCurrentUserId();
$db = getDB();

if ($targetUserId === $blockerId) {
    http_response_code(400);
    echo json_encode(['error' => 'Cannot block yourself']);
    exit;
}

if ($action === 'block') {
    try {
        $stmt = $db->prepare("INSERT IGNORE INTO blocks (blocker_id, blocked_id) VALUES (?, ?)");
        $stmt->execute([$blockerId, $targetUserId]);
        echo json_encode(['success' => true, 'action' => 'blocked']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to block']);
    }
} else {
    $stmt = $db->prepare("DELETE FROM blocks WHERE blocker_id = ? AND blocked_id = ?");
    $stmt->execute([$blockerId, $targetUserId]);
    echo json_encode(['success' => true, 'action' => 'unblocked']);
}
