<?php
/**
 * Delete a message
 * POST: message_id
 * Only sender can delete own message.
 */

header('Content-Type: application/json');
require_once '../auth.php';
require_once '../db.php';

requireAuth();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$messageId = isset($input['message_id']) ? (int) $input['message_id'] : 0;

if ($messageId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid message ID']);
    exit;
}

$currentUserId = (int) getCurrentUserId();
$db = getDB();

// Get message and verify sender
$stmt = $db->prepare("SELECT id, chat_id, sender_id FROM messages WHERE id = ?");
$stmt->execute([$messageId]);
$msg = $stmt->fetch();

if (!$msg) {
    http_response_code(404);
    echo json_encode(['error' => 'Message not found']);
    exit;
}

if ((int) $msg['sender_id'] !== $currentUserId) {
    http_response_code(403);
    echo json_encode(['error' => 'You can only delete your own messages']);
    exit;
}

// Verify user is in this chat
$stmt = $db->prepare("SELECT id FROM chats WHERE id = ? AND (user1_id = ? OR user2_id = ?)");
$stmt->execute([$msg['chat_id'], $currentUserId, $currentUserId]);
if (!$stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['error' => 'Access denied']);
    exit;
}

// Delete message
$stmt = $db->prepare("DELETE FROM messages WHERE id = ? AND sender_id = ?");
$stmt->execute([$messageId, $currentUserId]);

if ($stmt->rowCount() === 0) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to delete message']);
    exit;
}

echo json_encode(['success' => true, 'message_id' => $messageId]);
