<?php
/**
 * Find user by username
 * GET: ?username=...
 */

header('Content-Type: application/json');
require_once '../auth.php';
require_once '../db.php';

requireAuth();

$username = trim($_GET['username'] ?? '');

if (empty($username)) {
    http_response_code(400);
    echo json_encode(['error' => 'Username parameter is required']);
    exit;
}

$currentUserId = (int) getCurrentUserId();
$db = getDB();

try {
    $stmt = $db->prepare("
        SELECT u.id, u.username, u.profile_pic_url FROM users u
        LEFT JOIN blocks b ON b.blocker_id = ? AND b.blocked_id = u.id
        WHERE u.username = ? AND u.id != ? AND (b.id IS NULL)
    ");
    $stmt->execute([$currentUserId, $username, $currentUserId]);
    $user = $stmt->fetch();
} catch (PDOException $e) {
    $stmt = $db->prepare("SELECT id, username, profile_pic_url FROM users WHERE username = ? AND id != ?");
    $stmt->execute([$username, $currentUserId]);
    $user = $stmt->fetch();
}

if (!$user) {
    http_response_code(404);
    echo json_encode(['error' => 'User not found']);
    exit;
}

echo json_encode([
    'user' => [
        'id' => (int)$user['id'],
        'username' => $user['username'],
        'profile_pic_url' => $user['profile_pic_url']
    ]
]);
