<?php
/**
 * Get messages for a chat
 * GET: ?chat_id=...&after_id=... (optional, for polling)
 */

header('Content-Type: application/json');
require_once '../auth.php';
require_once '../db.php';

requireAuth();

$chatId = (int)($_GET['chat_id'] ?? 0);
$afterId = isset($_GET['after_id']) ? (int)$_GET['after_id'] : 0;

if ($chatId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Chat ID is required']);
    exit;
}

$currentUserId = (int) getCurrentUserId();
$db = getDB();

// Verify user is part of this chat
$stmt = $db->prepare("SELECT id FROM chats WHERE id = ? AND (user1_id = ? OR user2_id = ?)");
$stmt->execute([$chatId, $currentUserId, $currentUserId]);
if (!$stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['error' => 'Access denied']);
    exit;
}

// Get messages (only new ones if after_id is provided)
if ($afterId > 0) {
    $stmt = $db->prepare("
        SELECT 
            m.id,
            m.sender_id,
            m.message_text,
            m.media_url,
            m.media_type,
            m.created_at,
            u.username as sender_username,
            u.profile_pic_url as sender_profile_pic
        FROM messages m
        INNER JOIN users u ON m.sender_id = u.id
        WHERE m.chat_id = ? AND m.id > ?
        ORDER BY m.created_at ASC
    ");
    $stmt->execute([$chatId, $afterId]);
} else {
    $stmt = $db->prepare("
        SELECT 
            m.id,
            m.sender_id,
            m.message_text,
            m.media_url,
            m.media_type,
            m.created_at,
            u.username as sender_username,
            u.profile_pic_url as sender_profile_pic
        FROM messages m
        INNER JOIN users u ON m.sender_id = u.id
        WHERE m.chat_id = ?
        ORDER BY m.created_at ASC
    ");
    $stmt->execute([$chatId]);
}

$messages = $stmt->fetchAll();

$formattedMessages = array_map(function($msg) use ($currentUserId) {
    $sid = (int) $msg['sender_id'];
    return [
        'id' => (int)$msg['id'],
        'sender_id' => $sid,
        'sender_username' => $msg['sender_username'],
        'sender_profile_pic' => $msg['sender_profile_pic'],
        'is_sender' => $sid === $currentUserId,
        'message_text' => $msg['message_text'],
        'media_url' => $msg['media_url'],
        'media_type' => $msg['media_type'],
        'created_at' => $msg['created_at']
    ];
}, $messages);

echo json_encode(['messages' => $formattedMessages]);
