<?php
/**
 * Get user details (for info modal)
 * GET: ?user_id=...
 */

header('Content-Type: application/json');
require_once '../auth.php';
require_once '../db.php';

requireAuth();

$userId = (int) ($_GET['user_id'] ?? 0);
if ($userId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid user_id']);
    exit;
}

$db = getDB();
$stmt = $db->prepare("SELECT id, username, profile_pic_url, created_at, last_seen FROM users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    http_response_code(404);
    echo json_encode(['error' => 'User not found']);
    exit;
}

echo json_encode([
    'user' => [
        'id' => (int) $user['id'],
        'username' => $user['username'],
        'profile_pic_url' => $user['profile_pic_url'],
        'created_at' => $user['created_at'],
        'last_seen' => $user['last_seen'],
    ]
]);
