<?php
/**
 * Authentication helper functions
 */

require_once 'db.php';

// Use HTTP: session cookie must not be secure so it works over HTTP
if (defined('USE_HTTP') && USE_HTTP) {
    session_set_cookie_params([
        'lifetime' => defined('SESSION_LIFETIME') ? SESSION_LIFETIME : 86400,
        'path' => '/',
        'domain' => '',
        'secure' => false,
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
}

session_start();

function isLoggedIn() {
    return isset($_SESSION['user_id']) && isset($_SESSION['username']);
}

function requireAuth() {
    if (!isLoggedIn()) {
        http_response_code(401);
        echo json_encode(['error' => 'Authentication required']);
        exit;
    }
}

function getCurrentUserId() {
    return $_SESSION['user_id'] ?? null;
}

function getCurrentUsername() {
    return $_SESSION['username'] ?? null;
}

function updateLastSeen($userId) {
    $db = getDB();
    $stmt = $db->prepare("UPDATE users SET last_seen = NOW() WHERE id = ?");
    $stmt->execute([$userId]);
}
