<?php
/**
 * Configuration file for Chat Application
 */

// Server protocol: use HTTP (not HTTPS)
define('USE_HTTP', true);
define('APP_PROTOCOL', 'http');

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'chat_app_pro');
define('DB_USER', 'root');
define('DB_PASS', '');

// External Media Server Configuration
// IMPORTANT: Update this to your external media server URL
define('MEDIA_SERVER_URL', 'http://10.227.252.250/chat_app_pro/media_server/upload.php');
// Allow current server host for media URL validation (supports localhost, IPs, domains)
define('MEDIA_SERVER_DOMAIN', isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localhost');

// Session configuration
define('SESSION_LIFETIME', 86400); // 24 hours

// File upload limits
define('MAX_PROFILE_PIC_SIZE', 10 * 1024 * 1024); // 10 MB
define('MAX_IMAGE_SIZE', 20 * 1024 * 1024); // 20 MB
define('MAX_VIDEO_SIZE', 500 * 1024 * 1024); // 500 MB

// Allowed file types
define('ALLOWED_PROFILE_PIC_TYPES', ['image/jpeg', 'image/jpg', 'image/png', 'image/webp']);
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/jpg', 'image/png', 'image/webp', 'image/gif']);
define('ALLOWED_VIDEO_TYPES', ['video/mp4']);

// Rate limiting (messages per minute)
define('RATE_LIMIT_MESSAGES', 30);

// Timezone
date_default_timezone_set('UTC');
