// API Configuration — server uses HTTP
const USE_HTTP = true;
const API_BASE = 'api';

// Auto-detect media server URL based on current host (fixes CORS localhost issue)
function getMediaServerURL() {
    const protocol = window.location.protocol;
    const host = window.location.host;
    const pathname = window.location.pathname;
    // Extract base path (e.g., /chat_app_pro from /chat_app_pro/home.html)
    const basePath = pathname.substring(0, pathname.lastIndexOf('/'));
    return `${protocol}//${host}${basePath}/media_server/upload.php`;
}

const MEDIA_SERVER_URL = getMediaServerURL();

// Redirect to login on 401 (stops polling, avoids console spam)
function redirectToLogin() {
    const path = window.location.pathname;
    const base = path.substring(0, path.lastIndexOf('/') + 1) || '/';
    window.location.replace(base + 'index.html');
}

// Helper function to make API calls
async function apiCall(endpoint, options = {}) {
    const url = `${API_BASE}/${endpoint}`;
    const defaultOptions = {
        headers: {
            'Content-Type': 'application/json',
        },
        credentials: 'include', // Include cookies for session
    };
    
    const response = await fetch(url, { ...defaultOptions, ...options });
    const data = await response.json().catch(() => ({}));
    
    if (response.status === 401) {
        redirectToLogin();
        throw new Error('Authentication required');
    }
    
    if (!response.ok) {
        throw new Error(data.error || 'Request failed');
    }
    
    return data;
}
