// Dark mode toggle - persists in localStorage

const STORAGE_KEY = 'chatAppDarkMode';

function isDarkMode() {
    return localStorage.getItem(STORAGE_KEY) === '1';
}

function applyDarkMode(dark) {
    if (dark) {
        document.documentElement.classList.add('dark');
    } else {
        document.documentElement.classList.remove('dark');
    }
}

function initDarkMode() {
    const dark = isDarkMode();
    applyDarkMode(dark);
    return dark;
}

function toggleDarkMode() {
    const next = !isDarkMode();
    localStorage.setItem(STORAGE_KEY, next ? '1' : '0');
    applyDarkMode(next);
    return next;
}

// Run on load if script included
if (typeof document !== 'undefined') {
    initDarkMode();
}
